/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.util.exceptions.SerializationException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;

public class DynamicHolder<T> {
    private T value;
    private Supplier<T> valueCreator;
    private Loader<T> loader;
    private Saver<T> saver;
    private Writer<T> encoder;
    private Reader<T> decoder;
    private boolean synced = false;
    private boolean requireRegistries = false;

    protected DynamicHolder(Supplier<T> valueCreator, Consumer<DynamicHolder<T>> loader) {
        this.valueCreator = valueCreator;
        this.loader = (holder, registryAccess) -> loader.accept(holder);
    }

    protected DynamicHolder(Supplier<T> valueCreator, Loader<T> loader) {
        this.valueCreator = valueCreator;
        this.loader = loader;
    }

    public static <T> DynamicHolder<T> createWithRegistries(Supplier<T> valueCreator, Loader<T> loader) {
        DynamicHolder<T> holder = new DynamicHolder<T>(valueCreator, loader);
        holder.value = valueCreator.get();
        holder.requireRegistries = true;
        return holder;
    }

    public static <T> DynamicHolder<T> create(Supplier<T> valueCreator, Consumer<DynamicHolder<T>> loader) {
        DynamicHolder<T> holder = new DynamicHolder<T>(valueCreator, loader);
        holder.value = valueCreator.get();
        return holder;
    }

    public static <T> DynamicHolder<T> createSyncedWithRegistries(Supplier<T> valueCreator, Loader<T> loader, Writer<T> encoder, Reader<T> decoder, Saver<T> saver) {
        DynamicHolder<T> holder = new DynamicHolder<T>(valueCreator, loader);
        holder.value = valueCreator.get();
        holder.encoder = encoder;
        holder.decoder = decoder;
        holder.saver = saver;
        holder.synced = true;
        holder.requireRegistries = true;
        return holder;
    }

    public static <T> DynamicHolder<T> createSynced(Supplier<T> valueCreator, Consumer<DynamicHolder<T>> loader, Function<T, CompoundTag> encoder, Function<CompoundTag, T> decoder, Consumer<T> saver) {
        DynamicHolder<T> holder = new DynamicHolder<T>(valueCreator, loader);
        holder.value = valueCreator.get();
        holder.encoder = (val, registryAccess) -> (CompoundTag)encoder.apply(val);
        holder.decoder = (tag, registryAccess) -> decoder.apply(tag);
        holder.saver = (val, registryAccess) -> saver.accept(val);
        holder.synced = true;
        return holder;
    }

    public T get() {
        if (this.requireRegistries) {
            throw new RuntimeException("RegistryAccess is required for this DynamicHolder, yet none was provided.");
        }
        if (this.value == null) {
            this.load(true);
        }
        return this.value;
    }

    public T get(RegistryAccess registryAccess) {
        if (this.value == null) {
            this.load(registryAccess, true);
        }
        return this.value;
    }

    public void set(T value) {
        this.value = value;
    }

    public void setUnsafe(Object value) {
        this.value = value;
    }

    public void load(boolean replace) {
        if (replace) {
            this.value = this.valueCreator.get();
        }
        this.loader.load(this, null);
    }

    public void load(RegistryAccess registryAccess, boolean replace) {
        if (replace) {
            this.value = this.valueCreator.get();
        }
        this.loader.load(this, registryAccess);
    }

    public CompoundTag encode(RegistryAccess registryAccess) {
        if (!this.synced) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)SerializationException.serialize(this.value, "Tried to encode non-synced DynamicHolder", null));
        }
        try {
            return this.encoder.write(this.get(registryAccess), registryAccess);
        }
        catch (Exception e) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)SerializationException.serialize(this.value, "Failed to encode DynamicHolder for type " + this.value.getClass().getSimpleName(), e));
        }
    }

    public void decode(CompoundTag tag, RegistryAccess registryAccess) {
        if (!this.synced) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Tried to decode non-synced DynamicHolder", null));
        }
        try {
            this.value = this.decoder.read(tag, registryAccess);
        }
        catch (Exception e) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Failed to decode DynamicHolder for type " + this.value.getClass().getSimpleName(), e));
        }
    }

    public void save(RegistryAccess registryAccess) {
        if (!this.synced) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Tried to save non-synced DynamicHolder", null));
        }
        try {
            this.saver.save(this.get(registryAccess), registryAccess);
        }
        catch (Exception e) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Failed to save DynamicHolder for type " + this.value.getClass().getSimpleName(), e));
        }
    }

    public void reset() {
        this.value = this.valueCreator.get();
    }

    public boolean isSynced() {
        return this.synced;
    }

    public boolean requiresRegistries() {
        return this.requireRegistries;
    }

    @FunctionalInterface
    public static interface Loader<T> {
        public void load(DynamicHolder<T> var1, RegistryAccess var2);
    }

    @FunctionalInterface
    public static interface Writer<T> {
        public CompoundTag write(T var1, RegistryAccess var2);
    }

    @FunctionalInterface
    public static interface Reader<T> {
        public T read(CompoundTag var1, RegistryAccess var2);
    }

    @FunctionalInterface
    public static interface Saver<T> {
        public void save(T var1, RegistryAccess var2);
    }
}

